#include "SPI.h"
#include "ATMEGA328.h"
#include <avr/io.h>
#include <avr/interrupt.h>

//SPI of Atmega328p//
void spi_init_master (void)
{
	//Put MOSI, SCK and SS as output
	pinModeB = PB5_output | PB3_output | PB2_output;
	
	//Configuration of the SPI
	SPI_Control_Register = SPI_Interrupt_Disable | SPI_Enable | SPI_MSB | SPI_Master | SPI_Mode_00 | SPI_fosc4;
	//Enable double speed modus
	SPI_Status_Register = SPI_Double_Speed;

	sei();
}

uint8_t spi_tranceiver (uint8_t data)
{
	//Byte that the master will send
	SPI_Data_Register = data;
	//Wait until the transmission is complete
	while(!(SPI_Status_Register & SPI_Interrupt_Flag ));
	//Return the data from the slave
	return (SPI_Data_Register);
	
}


//Software implemented SPI//
void softspi_init_master(void)
{
	//Set clock and MOSI as output, use PORTD: PD3 for the clock and PD4 for MOSI
	softspi_clk_DDR |= softspi_clk_MSK;
	softspi_MOSI_DDR |= softspi_MOSI_MSK;
}

void softspi_clk_low(void)
{
	//Set clock low
	softspi_clk_PORT &= ~softspi_clk_MSK;
}

void softspi_clk_high(void)
{
	//Set clock high
	softspi_clk_PORT |= softspi_clk_MSK;
}

void softspi_MOSI_low(void)
{
	//Set MOSI low
	softspi_MOSI_PORT &= ~softspi_MOSI_MSK;
}

void softspi_MOSI_high(void)
{
	//Set MOSI high
	softspi_MOSI_PORT |= softspi_MOSI_MSK;
}

//Implements SPI mode 00
uint8_t softspi_tranceiver_00(uint8_t byte)
{
	for (uint8_t i=0; i<8; i++)
	{
		if (byte & 0b10000000)
		{
			softspi_MOSI_high();
		}
		else
		{
			softspi_MOSI_low();
		}
		byte <<= 1;
		softspi_clk_high();
		if (MISO)
		{
			byte |= 0b00000001;
		}
		softspi_clk_low();
	}
	return (byte);
}

//Implements SPI mode 11
uint8_t softspi_tranceiver_11(uint8_t byte)
{
	for (uint8_t i=0; i<8; i++)
	{
		if (byte & 0b10000000)
		{
			softspi_MOSI_high();
		}
		else
		{
			softspi_MOSI_low();
		}
		softspi_clk_low();
		byte <<= 1;
		if (MISO)
		{
			byte |= 0b00000001;
		}
		softspi_clk_high();
	}
	return (byte);
}

